/***********************************************************
File: BMC36M041_TRX.ino
Description: Remote control of a 7-segment display with a slide touch sensor        
***********************************************************/
//include libraries
#include  "BMC36M0x1.h"
#include "BMK54T004.h"
#include "BMD11M134.h"
#include <MsTimer.h>
//define objects
BMC36M0x1     BMC36(&Serial1);      //BMC36M0x1,use Serial1
BMK54T004     BMK54(2,&Wire);
BMD11M134     Display(&Wire2);

bool Flag_Pairing = FALSE; //配對  FALSE:未配對  TURE:已配對
bool Flag_PairSuccess = FALSE; //配對情況 FALSE:失敗  TURE:成功
uint8_t TXDATA[16] = {0},RXDATA[32] = {0};//發送接收Buf
uint8_t DATA,STATUS,len;
uint8_t Flag_RX = 1;       //模式 1:發送模式 0:接收模式
uint8_t keyValue = 0;      //上次keyValue
uint8_t keyValueTemp = 0;  //當前keyValue
uint8_t slideValue = 0;    //上次slideValue
uint8_t slideValueTemp = 0;//當前slideValue
uint8_t slideFlag = 0;     //刷新Slide按下標誌

uint8_t digital_Num = 0;   //變化的數碼管:0~3
uint8_t digital_Value1 = 0;//數碼管0數值
uint8_t digital_Value2 = 0;//數碼管1數值
uint8_t digital_Value3 = 0;//數碼管2數值
uint8_t digital_Value4 = 0;//數碼管3數值
uint8_t char_Temp = '0';   //變化的數值字符
uint8_t digitalNumChoiceFlag = 0;//數碼管選擇標誌位 0:未選擇 1-19：循環滅亮 20：取消選擇 
//volatile 


void setup()
{
  /*  Serial monitor  */
  Serial.begin(9600); 

  /*  BMK54T004  */
  BMK54.begin();
  BMK54.setAllThresholdLevel(2);
   
  /*  BMD11M134  */
  Display.begin();
  Display.printChar(1, ' ', 0);
  Display.printChar(1, ' ', 1);
  Display.printChar(1, ' ', 2);
  Display.printChar(1, ' ', 3);
  Display.updateDisplay();

  /*  BMC36M0x1  */
  BMC36.begin(BDR_38400);          //set BMduino and BMC36 uart baudrate
  BMC36.setDeviceRole(Peer); 

  if(BMC36.isPaired())//如果配對過,則不重新配對
  {
    Flag_Pairing = TRUE;
    Flag_PairSuccess = TRUE;
    Display.printChar(1, '0', 0);
    Display.printChar(1, '0', 1);
    Display.printChar(1, '0', 2);
    Display.printChar(1, '0', 3);
    Display.updateDisplay();
  }

  /*  timer  */
  MsTimer::set(500, digitalNumChoice);
  MsTimer::start();
}

void loop() 
{              
  RFMessage_Process();                        
  Handle_RFPacket_Process();      
}

/******************************************************
Description: Scan KEY         
Input:  none            
Output: none         
Return: KEY Value         
Others: put this funtion to loop,circularly Scan KEY         
*******************************************************/
uint8_t Sys_KEY(void)
{
    keyValueTemp = 0;
    if(BMK54.getINT() == 0)
    {
        keyValueTemp = BMK54.readKeyValue();
        if(keyValueTemp != keyValue)
        {
          keyValue = keyValueTemp;
          return keyValueTemp;
        }    
    } 
    return 0;
}
/******************************************************
Description: Scan Slide         
Input:  none            
Output: none         
Return: Slide Value         
Others: put this funtion to loop,circularly Scan Slide         
*******************************************************/
uint8_t Sys_Slide(void)
{   
    slideValueTemp = 0;
    if(BMK54.getINT() == 0)
    {
        slideValueTemp = BMK54.readSlideValue();
        if(slideFlag == 0)//刷新Slide按下的位置
        {
           slideValue = slideValueTemp;
           slideFlag = 1;
        }
        if(slideValueTemp != slideValue)//Slide 數值變化
        {
          if(digitalNumChoiceFlag != 0) //在5s範圍內,才變化
          {
             digitalNumChoiceFlag=0;//取消閃爍
             uint8_t digital_Value_Temp = 0;
             switch(digital_Num)//哪個數碼管需要變化
             {
               case 0:
                 digital_Value_Temp = digital_Value1;
                 break;
               case 1:
                 digital_Value_Temp = digital_Value2;
                 break;
               case 2:
                 digital_Value_Temp = digital_Value3;
                 break;
               case 3:
                 digital_Value_Temp = digital_Value4;
                 break;
             }
             if(slideValueTemp > slideValue)//右滑
             {
               digital_Value_Temp = digital_Value_Temp+slideValueTemp-slideValue;
             }
             if(slideValueTemp < slideValue)//左滑
             {
               digital_Value_Temp = digital_Value_Temp-(slideValue-slideValueTemp);
             }
             
             if((digital_Value_Temp <= 0) || (digital_Value_Temp >= 200))//避免超出範圍
             {
               digital_Value_Temp = 0;
             }
             if(digital_Value_Temp >= 15)
             {
               digital_Value_Temp = 15;
             }
            Display.printChar(1,valueToChar(digital_Value_Temp),digital_Num);
            Display.updateDisplay();
         
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            TXDATA[0]=0x55;TXDATA[1]=digital_Num;TXDATA[2]=digital_Value_Temp;
            BMC36.writeRFData(SA_Peer,3,TXDATA);
            BMC36.setMode(Rx_Mode);Flag_RX =0;
         
            switch(digital_Num)//變化的數碼管保存
             {
               case 0:
                 digital_Value1 = digital_Value_Temp;
                 break;
               case 1:
                 digital_Value2 = digital_Value_Temp;
                 break;
               case 2:
                 digital_Value3 = digital_Value_Temp;
                 break;
               case 3:
                 digital_Value4 = digital_Value_Temp;
                 break;
             }
             digitalNumChoiceFlag=1;//繼續閃爍
          }
          slideValue = slideValueTemp;
          return slideValueTemp;
        
        }   
    } 
    else
    {
      slideFlag = 0;
    }
    return 0;
}

/******************************************************
Description: Send commands according to keyvalue        
Input:  none            
Output: none         
Return: none         
Others: put this funtion to loop         
*******************************************************/
void RFMessage_Process()
{
  switch(Sys_KEY())
  {
    case 0x01:
         if(Flag_Pairing == FALSE || Flag_PairSuccess == FALSE)//未配對
         {
            BMC36.setMode(Pairing_Mode);                                                 //send pairing mode command
            Flag_Pairing = TRUE; 
            Flag_PairSuccess = FALSE; 
         }
         if(Flag_PairSuccess)//配對成功
         {
            digital_Num = 0;
            Display.printChar(1, ' ', digital_Num);
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            TXDATA[0]=0x55;TXDATA[1]=0x10;TXDATA[2]=0x00;//告知另一端有KEY按下
            BMC36.writeRFData(SA_Peer,3,TXDATA);
            BMC36.setMode(Rx_Mode);Flag_RX =0;
            
            Display.printChar(1, valueToChar(digital_Value1), 0);
            Display.printChar(1, valueToChar(digital_Value2), 1);
            Display.printChar(1, valueToChar(digital_Value3), 2);
            Display.printChar(1, valueToChar(digital_Value4), 3);
            Display.updateDisplay();
            digitalNumChoiceFlag = 1;
         }
         
         Serial.println("KEY1");
         break;
    case 0x02:
         if((Flag_Pairing == TRUE) && (Flag_PairSuccess == FALSE))//配對中
         {
            BMC36.writePairPackage(SA_Peer_Pair|SA_Pairing);
            Serial.println("peidui");
         }
         if(Flag_PairSuccess)//配對成功
         {
            digital_Num = 1;
            Display.printChar(1, ' ', digital_Num);
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            TXDATA[0]=0x55;TXDATA[1]=0x10;TXDATA[2]=0x00;//告知另一端有KEY按下
            BMC36.writeRFData(SA_Peer,3,TXDATA);
            BMC36.setMode(Rx_Mode);Flag_RX =0;
            
            Display.printChar(1, valueToChar(digital_Value1), 0);
            Display.printChar(1, valueToChar(digital_Value2), 1);
            Display.printChar(1, valueToChar(digital_Value3), 2);
            Display.printChar(1, valueToChar(digital_Value4), 3);
            Display.updateDisplay();
            digitalNumChoiceFlag = 1;
         }
         break;
         Serial.println("KEY2");
    case 0x04:
         if(Flag_PairSuccess)//配對成功
         {
            digital_Num = 2;
            Display.printChar(1, ' ', digital_Num);
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            TXDATA[0]=0x55;TXDATA[1]=0x10;TXDATA[2]=0x00;//告知另一端有KEY按下
            BMC36.writeRFData(SA_Peer,3,TXDATA);
            BMC36.setMode(Rx_Mode);Flag_RX =0;
            
            Display.printChar(1, valueToChar(digital_Value1), 0);
            Display.printChar(1, valueToChar(digital_Value2), 1);
            Display.printChar(1, valueToChar(digital_Value3), 2);
            Display.printChar(1, valueToChar(digital_Value4), 3);
            Display.updateDisplay();
            digitalNumChoiceFlag = 1;
         }
         Serial.println("KEY3");
         break;
    case 0x08:
         if(Flag_PairSuccess)//配對成功
         {
            digital_Num = 3;
            Display.printChar(1, ' ', digital_Num);
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            TXDATA[0]=0x55;TXDATA[1]=0x10;TXDATA[2]=0x00;//告知另一端有KEY按下
            BMC36.writeRFData(SA_Peer,3,TXDATA);
            BMC36.setMode(Rx_Mode);Flag_RX =0;
            
            Display.printChar(1, valueToChar(digital_Value1), 0);
            Display.printChar(1, valueToChar(digital_Value2), 1);
            Display.printChar(1, valueToChar(digital_Value3), 2);
            Display.printChar(1, valueToChar(digital_Value4), 3);
            Display.updateDisplay();
            digitalNumChoiceFlag = 1;
         }
         Serial.println("KEY4");
         break;
     case 0x0F:  //同時按下KEY1-KEY4,代表進入重新配對
         Flag_Pairing = FALSE;
         Flag_PairSuccess = FALSE;
            Display.printChar(1, ' ', 0);
            Display.printChar(1, ' ', 1);
            Display.printChar(1, ' ', 2);
            Display.printChar(1, ' ', 3);
            Display.updateDisplay();
            digitalNumChoiceFlag = 0;
            BMC36.setMode(Sleep_Mode);Flag_RX =1;
            Serial.println("KEYALL");
         break;
     default:
         break;
  }

  Sys_Slide();
}

/******************************************************
Description: dispose RF Packet         
Input:  none            
Output: none         
Return: none         
Others: put this funtion to loop         
*******************************************************/
void Handle_RFPacket_Process()
{
    if(Flag_Pairing)
      {
       STATUS = BMC36.getPairStatus(); 
       if(STATUS == 1) //pairing success
        {
          //Flag_Pairing = FALSE;
          Flag_PairSuccess = TRUE;
          Serial.println("Pair Success");
          BMC36.setMode(Rx_Mode);Flag_RX =0;   
            Display.printChar(1, '0', 0);
            Display.printChar(1, '0', 1);
            Display.printChar(1, '0', 2);
            Display.printChar(1, '0', 3);
            Display.updateDisplay();                                                  
        }  
       if(STATUS == 2)  //pairing fail          
        {
          //Flag_Pairing = FALSE;
          Flag_PairSuccess = FALSE;
        }   
        if(STATUS == 3) //pairing timout
        {
          //Flag_Pairing = FALSE;
          Flag_PairSuccess = FALSE;                                                            
        }                                              
      }
   
      if(Flag_PairSuccess)
      {
        if(BMC36.isInfoAvailable())  
        {
           STATUS = BMC36.readRFData(RXDATA,len);  
           if(STATUS == 1)  //After the match is successful, data is received
           { 
             Serial.print("RXDATA[]:");
             for(uint8_t temp=0;temp<len;temp++)
             {
               Serial.print(RXDATA[temp],HEX);
               Serial.print(" ");
              }
             Serial.println(" ");
             Display.printChar(1,valueToChar(RXDATA[2]),RXDATA[1]);
             switch(RXDATA[1])
             {
               case 0:
                    digital_Value1 = RXDATA[2];
                    break;
               case 1:
                    digital_Value2 = RXDATA[2];
                    break;
               case 2:
                    digital_Value3 = RXDATA[2];
                    break;
               case 3:
                    digital_Value4 = RXDATA[2];
                    break;
               case 0x10: //一端有KEY按下,另一端取消原有的閃爍
                    digitalNumChoiceFlag = 0;
                    Display.printChar(1, valueToChar(digital_Value1), 0);
                    Display.printChar(1, valueToChar(digital_Value2), 1);
                    Display.printChar(1, valueToChar(digital_Value3), 2);
                    Display.printChar(1, valueToChar(digital_Value4), 3);
                    break;
               default:
                    break;
             }
             Display.updateDisplay();
             digitalNumChoiceFlag = 0;
           }
        }
     }
}
void digitalNumChoice()//5s內,閃爍digital_Num位
{
  if(digitalNumChoiceFlag != 0)
  {
    if((digitalNumChoiceFlag % 2) != 0)
    {
       Display.printChar(1, ' ', digital_Num);
       Display.updateDisplay(); //數碼管滅
    }
    else
    {
      switch(digital_Num)
      {
        case 0:
            Display.printChar(1, valueToChar(digital_Value1), 0);
            Display.updateDisplay();
            break;
        case 1:
            Display.printChar(1, valueToChar(digital_Value2), 1);
            Display.updateDisplay();
            break;
        case 2:
            Display.printChar(1, valueToChar(digital_Value3), 2);
            Display.updateDisplay();
            break;
        case 3:
            Display.printChar(1, valueToChar(digital_Value4), 3);
            Display.updateDisplay();
            break;
        default:
            break;
      }
    }
    digitalNumChoiceFlag++;
    if(digitalNumChoiceFlag==11)
    {
      digitalNumChoiceFlag=0;
      keyValue = 0;//取消KEY選擇
    }
    
  }
  Serial.println(digitalNumChoiceFlag);
}
uint8_t valueToChar(uint8_t value)
{
         switch(value)//數碼管變化
         {
           case 0:
              return '0';
           case 1:
              return '1';
           case 2:
              return '2';
           case 3:
              return '3';
           case 4:
              return '4';
           case 5:
              return '5';
           case 6:
              return '6';
           case 7:
              return '7';
           case 8:
              return '8';
           case 9:
              return '9';
           case 10:
              return 'A';
           case 11:
              return 'B';
           case 12:
              return 'C';
           case 13:
              return 'D';
           case 14:
              return 'E';
           case 15:
              return 'F';
         }
}
